/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json.formatter;

import beaver.Symbol;
import com.aptana.editor.json.formatter.JSONPrimitiveFormatNode;
import com.aptana.editor.json.formatter.nodes.JSONArrayFormatNode;
import com.aptana.editor.json.formatter.nodes.JSONEntryFormatNode;
import com.aptana.editor.json.formatter.nodes.JSONObjectFormatNode;
import com.aptana.editor.json.formatter.nodes.JSONRootFormatNode;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.AbstractFormatterNodeBuilder;
import com.aptana.formatter.nodes.FormatterBlockWithBeginEndNode;
import com.aptana.formatter.nodes.FormatterEmptyNode;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import com.aptana.json.core.parsing.ast.JSONArrayNode;
import com.aptana.json.core.parsing.ast.JSONEntryNode;
import com.aptana.json.core.parsing.ast.JSONFalseNode;
import com.aptana.json.core.parsing.ast.JSONNode;
import com.aptana.json.core.parsing.ast.JSONNullNode;
import com.aptana.json.core.parsing.ast.JSONNumberNode;
import com.aptana.json.core.parsing.ast.JSONObjectNode;
import com.aptana.json.core.parsing.ast.JSONParseRootNode;
import com.aptana.json.core.parsing.ast.JSONStringNode;
import com.aptana.json.core.parsing.ast.JSONTreeWalker;
import com.aptana.json.core.parsing.ast.JSONTrueNode;
import com.aptana.parsing.ast.IParseNode;

public class JSONFormatterNodeBuilder
extends AbstractFormatterNodeBuilder {
    private FormatterDocument _document;

    public IFormatterContainerNode build(IParseNode parseResult, FormatterDocument document) {
        this._document = document;
        JSONRootFormatNode rootNode = new JSONRootFormatNode((IFormatterDocument)document);
        this.start((IFormatterContainerNode)rootNode);
        JSONFormattingWalker walker = new JSONFormattingWalker();
        JSONParseRootNode jsonRootNode = (JSONParseRootNode)parseResult;
        jsonRootNode.accept((JSONTreeWalker)walker);
        this.checkedPop((IFormatterContainerNode)rootNode, document.getLength());
        return rootNode;
    }

    public class JSONFormattingWalker
    extends JSONTreeWalker {
        protected void visit(IParseNode node) {
            if (node instanceof JSONNode) {
                ((JSONNode)node).accept((JSONTreeWalker)this);
            }
        }

        public void visit(JSONArrayNode node) {
            JSONArrayFormatNode formatNode = new JSONArrayFormatNode((IFormatterDocument)JSONFormatterNodeBuilder.this._document, node);
            this.addComposite(formatNode, (JSONNode)node);
        }

        public void visit(JSONObjectNode node) {
            JSONObjectFormatNode formatNode = new JSONObjectFormatNode((IFormatterDocument)JSONFormatterNodeBuilder.this._document, node);
            this.addComposite(formatNode, (JSONNode)node);
        }

        public void visit(JSONEntryNode node) {
            JSONEntryFormatNode entry = new JSONEntryFormatNode((IFormatterDocument)JSONFormatterNodeBuilder.this._document);
            IParseNode name = node.getFirstChild();
            Symbol colon = node.getColon();
            IParseNode value = node.getLastChild();
            IFormatterTextNode nameText = JSONFormatterNodeBuilder.createTextNode((IFormatterDocument)JSONFormatterNodeBuilder.this._document, (int)name.getStartingOffset(), (int)(name.getEndingOffset() + 1));
            IFormatterTextNode colonText = JSONFormatterNodeBuilder.createTextNode((IFormatterDocument)JSONFormatterNodeBuilder.this._document, (int)colon.getStart(), (int)(colon.getEnd() + 1));
            entry.addChild((IFormatterNode)nameText);
            entry.addChild((IFormatterNode)colonText);
            JSONFormatterNodeBuilder.this.push((IFormatterContainerNode)entry);
            this.visit(value);
            JSONFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)entry, node.getEndingOffset() + 1);
        }

        public void visit(JSONFalseNode node) {
            this.addPrimitive((JSONNode)node);
        }

        public void visit(JSONNullNode node) {
            this.addPrimitive((JSONNode)node);
        }

        public void visit(JSONNumberNode node) {
            this.addPrimitive((JSONNode)node);
        }

        public void visit(JSONStringNode node) {
            this.addPrimitive((JSONNode)node);
        }

        public void visit(JSONTrueNode node) {
            this.addPrimitive((JSONNode)node);
        }

        public void addComposite(FormatterBlockWithBeginEndNode formatNode, JSONNode node) {
            int startingOffset = node.getStartingOffset();
            int endingOffset = node.getEndingOffset();
            IFormatterTextNode textNode = JSONFormatterNodeBuilder.createTextNode((IFormatterDocument)JSONFormatterNodeBuilder.this._document, (int)startingOffset, (int)(startingOffset + 1));
            formatNode.setBegin(textNode);
            JSONFormatterNodeBuilder.this.push((IFormatterContainerNode)formatNode);
            this.visitChildren(node);
            int lastOffset = node.hasChildren() ? node.getLastChild().getEndingOffset() : startingOffset;
            FormatterEmptyNode emptyNode = new FormatterEmptyNode((IFormatterDocument)JSONFormatterNodeBuilder.this._document);
            emptyNode.addChild((IFormatterNode)JSONFormatterNodeBuilder.createTextNode((IFormatterDocument)JSONFormatterNodeBuilder.this._document, (int)(lastOffset + 1), (int)endingOffset));
            formatNode.addChild((IFormatterNode)emptyNode);
            JSONFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatNode, endingOffset);
            textNode = JSONFormatterNodeBuilder.createTextNode((IFormatterDocument)JSONFormatterNodeBuilder.this._document, (int)endingOffset, (int)(endingOffset + 1));
            formatNode.setEnd(textNode);
        }

        public void addPrimitive(JSONNode node) {
            JSONPrimitiveFormatNode primitive = new JSONPrimitiveFormatNode((IFormatterDocument)JSONFormatterNodeBuilder.this._document, node);
            int startingOffset = node.getStartingOffset();
            int endingOffset = node.getEndingOffset();
            IFormatterTextNode textNode = JSONFormatterNodeBuilder.createTextNode((IFormatterDocument)JSONFormatterNodeBuilder.this._document, (int)startingOffset, (int)(endingOffset + 1));
            primitive.addChild((IFormatterNode)textNode);
            JSONFormatterNodeBuilder.this.push((IFormatterContainerNode)primitive);
            JSONFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)primitive, primitive.getEndOffset());
        }
    }
}

